
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Jean', lb=0)  # Assuming hours cannot be negative
    x2 = model.addVar(name='hours_worked_by_Mary', lb=0)  # Assuming hours cannot be negative

    # Define the objective function
    model.setObjective(5.11 * x1 + 6.35 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5 * x1 + 1 * x2 >= 19)
    model.addConstr(12 * x1 + 4 * x2 >= 18)
    model.addConstr(10 * x1 + 7 * x2 >= 21)
    model.addConstr(12 * x1 + 14 * x2 >= 10)
    model.addConstr(8 * x1 - 1 * x2 >= 0)
    model.addConstr(5 * x1 + 1 * x2 <= 34)
    model.addConstr(12 * x1 + 4 * x2 <= 31)
    model.addConstr(10 * x1 + 7 * x2 <= 52)
    model.addConstr(12 * x1 + 14 * x2 <= 42)

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Jean: {x1.varValue}")
        print(f"Hours worked by Mary: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
