
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
system_administrators = m.addVar(vtype=gp.GRB.INTEGER, name="system_administrators")
automatic_alerts = m.addVar(vtype=gp.GRB.INTEGER, name="automatic_alerts")
network_administrators = m.addVar(vtype=gp.GRB.INTEGER, name="network_administrators")

# Set objective function
m.setObjective(9*pen_testers + 4*system_administrators + 3*automatic_alerts + 7*network_administrators, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(27*pen_testers + 21*system_administrators + 31*automatic_alerts + 28*network_administrators <= 229, "network_latency_impact")
m.addConstr(5*pen_testers + 17*system_administrators + 29*automatic_alerts + 31*network_administrators <= 781, "dollar_cost")
m.addConstr(24*pen_testers + 22*system_administrators + 11*automatic_alerts + 7*network_administrators <= 497, "network_integrity_impact")
m.addConstr(21*pen_testers + 31*system_administrators + 31*automatic_alerts + 12*network_administrators <= 580, "data_accessibility_impact")

m.addConstr(21*system_administrators + 28*network_administrators >= 34, "c5")
m.addConstr(27*pen_testers + 31*automatic_alerts >= 43, "c6")
m.addConstr(27*pen_testers + 21*system_administrators + 31*automatic_alerts + 28*network_administrators >= 43, "c7")
m.addConstr(5*pen_testers + 17*system_administrators >= 160, "c8")
m.addConstr(29*automatic_alerts + 31*network_administrators >= 70, "c9")
m.addConstr(17*system_administrators + 31*network_administrators >= 165, "c10")
m.addConstr(5*pen_testers + 29*automatic_alerts >= 80, "c11")
m.addConstr(17*system_administrators + 29*automatic_alerts + 31*network_administrators >= 178, "c12")
m.addConstr(5*pen_testers + 17*system_administrators + 29*automatic_alerts + 31*network_administrators >= 178, "c13")
m.addConstr(24*pen_testers + 11*automatic_alerts >= 107, "c14")
m.addConstr(24*pen_testers + 7*network_administrators >= 75, "c15")
m.addConstr(22*system_administrators + 11*automatic_alerts >= 124, "c16")
m.addConstr(24*pen_testers + 22*system_administrators >= 87, "c17")
m.addConstr(11*automatic_alerts + 7*network_administrators >= 60, "c18")
m.addConstr(24*pen_testers + 22*system_administrators + 11*automatic_alerts + 7*network_administrators >= 60, "c19")
m.addConstr(21*pen_testers + 31*system_administrators >= 123, "c20")
m.addConstr(21*pen_testers + 31*automatic_alerts >= 77, "c21")
m.addConstr(31*system_administrators + 31*automatic_alerts >= 126, "c22")
m.addConstr(31*automatic_alerts + 12*network_administrators >= 96, "c23")
m.addConstr(21*pen_testers + 12*network_administrators >= 74, "c24")
m.addConstr(21*pen_testers + 31*system_administrators + 31*automatic_alerts + 12*network_administrators >= 74, "c25")
m.addConstr(4*pen_testers - 7*system_administrators >= 0, "c26")
m.addConstr(-1*pen_testers + 4*network_administrators >= 0, "c27")
m.addConstr(17*system_administrators + 29*automatic_alerts <= 681, "c28")
m.addConstr(5*pen_testers + 29*automatic_alerts <= 346, "c29")
m.addConstr(5*pen_testers + 17*system_administrators <= 316, "c30")
m.addConstr(29*automatic_alerts + 31*network_administrators <= 309, "c31")
m.addConstr(5*pen_testers + 17*system_administrators + 31*network_administrators <= 775, "c32")
m.addConstr(11*automatic_alerts + 7*network_administrators <= 411, "c33")
m.addConstr(31*automatic_alerts + 12*network_administrators <= 277, "c34")
m.addConstr(31*system_administrators + 12*network_administrators <= 166, "c35")
m.addConstr(31*system_administrators + 31*automatic_alerts <= 525, "c36")
m.addConstr(21*pen_testers + 31*system_administrators <= 166, "c37")
m.addConstr(21*pen_testers + 31*automatic_alerts <= 484, "c38")
m.addConstr(31*system_administrators + 31*automatic_alerts + 12*network_administrators <= 439, "c39")
m.addConstr(21*pen_testers + 31*system_administrators + 12*network_administrators <= 317, "c40")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

