
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="x0") #Bobby
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1") #Paul
    x2 = m.addVar(vtype=GRB.CONTINUOUS, name="x2") #Hank


    # Set objective function
    m.setObjective(8*x0**2 + 6*x0*x1 + 6*x1**2 + 3*x1*x2 + x0 + 9*x1 + x2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(5*x0 + 16*x1 + 15*x2 <= 283, "r0")
    m.addConstr(18*x0 + 15*x1 + 12*x2 <= 195, "r1")
    m.addConstr(11*x0 + 13*x1 + 5*x2 <= 92, "r2")
    m.addConstr(13*x0 + 6*x1 + 16*x2 <= 265, "r3")
    m.addConstr(5*x0**2 + 16*x1**2 >= 55, "c1")
    m.addConstr(5*x0 + 16*x1 + 15*x2 >= 55, "c2")
    m.addConstr(18*x0**2 + 12*x2**2 >= 50, "c3")
    m.addConstr(18*x0 + 15*x1 >= 22, "c4")
    m.addConstr(18*x0 + 15*x1 + 12*x2 >= 22, "c5")
    m.addConstr(13*x1 + 5*x2 >= 25, "c6")
    m.addConstr(11*x0 + 13*x1 >= 27, "c7")
    m.addConstr(11*x0**2 + 13*x1**2 + 5*x2**2 >= 27, "c8")
    m.addConstr(11*x0 + 13*x1 + 5*x2 >= 27, "c9")
    m.addConstr(13*x0 + 16*x2 >= 48, "c10")
    m.addConstr(6*x1 + 16*x2 >= 57, "c11")
    m.addConstr(13*x0**2 + 6*x1**2 + 16*x2**2 >= 88, "c12")
    m.addConstr(13*x0 + 6*x1 + 16*x2 >= 88, "c13")
    m.addConstr(x1 - 4*x2 >= 0, "c14")
    m.addConstr(18*x0 + 12*x2 <= 107, "c15")
    m.addConstr(18*x0 + 15*x1 + 12*x2 <= 102, "c16")
    m.addConstr(13*x1**2 + 5*x2**2 <= 47, "c17")
    m.addConstr(11*x0 + 5*x2 <= 59, "c18")
    m.addConstr(11*x0 + 13*x1 <= 34, "c19")
    m.addConstr(11*x0 + 13*x1 + 5*x2 <= 59, "c20")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
