
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0, type=gurobi.GRB.INTEGER) # hours worked by Bobby
    x1 = model.addVar(name="x1", lb=0) # hours worked by Paul
    x2 = model.addVar(name="x2", lb=0) # hours worked by Hank

    # Objective function
    model.setObjective(8*x0**2 + 6*x0*x1 + 6*x1**2 + 3*x1*x2 + x0 + 9*x1 + x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x0**2 + x1**2 >= 55)
    model.addConstr(x0 + x1 + x2 >= 55)
    model.addConstr(x0**2 + x2**2 >= 50)
    model.addConstr(x0 + x1 >= 22)
    model.addConstr(x0 + x1 + x2 >= 22)
    model.addConstr(x1 + x2 >= 25)
    model.addConstr(x0 + x1 >= 27)
    model.addConstr(x0**2 + x1**2 + x2**2 >= 27)
    model.addConstr(x0 + x1 + x2 >= 27)
    model.addConstr(13*x0 + 16*x2 >= 48)
    model.addConstr(6*x1 + 16*x2 >= 57)
    model.addConstr(169*x0**2 + 36*x1**2 + 256*x2**2 >= 88)
    model.addConstr(13*x0 + 6*x1 + 16*x2 >= 88)
    model.addConstr(x1 - 4*x2 >= 0)
    model.addConstr(18*x0 <= 195)
    model.addConstr(15*x1 <= 195)
    model.addConstr(12*x2 <= 195)
    model.addConstr(x1**2 + x2**2 <= 47)
    model.addConstr(x0 + x2 <= 59)
    model.addConstr(x0 + x1 <= 34)
    model.addConstr(x0 + x1 + x2 <= 59)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Bobby: ", x0.varValue)
        print("Hours worked by Paul: ", x1.varValue)
        print("Hours worked by Hank: ", x2.varValue)
    else:
        print("No solution found")

optimization_problem()
