
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
mary = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mary")
hank = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hank")
john = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="john")
jean = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="jean")
peggy = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peggy")
bill = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bill")
dale = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="dale")
ringo = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ringo")


# Set objective
obj = 6*mary**2 + 3*mary*hank + 7*mary*john + mary*jean + 3*mary*peggy + mary*dale + 7*mary*ringo + 4*hank**2 + 7*hank*john + 2*hank*jean + 6*hank*peggy + 3*hank*bill + 8*hank*dale + 9*hank*ringo + john**2 + 5*john*jean + 7*john*peggy + 9*john*bill + 6*john*dale + 6*john*ringo + 2*jean**2 + 7*jean*bill + 7*jean*dale + 7*peggy**2 + 9*peggy*dale + 2*peggy*ringo + 9*bill**2 + 7*bill*dale + 4*dale**2 + 4*dale*ringo + 8*john + 6*jean + 9*bill + 2*ringo
m.setObjective(obj, GRB.MAXIMIZE)

# Add constraints - Resource Constraints
m.addConstr(5*mary + 9*peggy >= 23, "r0_c1")
m.addConstr(8*john + 4*bill >= 43, "r0_c2")
m.addConstr(8*john + dale >= 36, "r0_c3")
m.addConstr(5*mary + dale >= 21, "r0_c4")
m.addConstr(5*mary + 9*jean >= 52, "r0_c5")
m.addConstr(6*hank + 9*peggy >= 36, "r0_c6")
m.addConstr(9*peggy + dale >= 59, "r0_c7")
m.addConstr(6*hank + 11*ringo >= 24, "r0_c8")
m.addConstr(9*jean + 9*peggy >= 49, "r0_c9")
m.addConstr(8*john + 9*jean >= 25, "r0_c10")
m.addConstr(5*mary + 11*ringo >= 60, "r0_c11")
m.addConstr(9*peggy + 11*ringo >= 44, "r0_c12")
m.addConstr(9*peggy + 4*bill >= 60, "r0_c13")
m.addConstr(5*mary + 8*john + 11*ringo >= 41, "r0_c14")
m.addConstr(6*hank**2 + 4*bill**2 + 11*ringo**2 >= 41, "r0_c15")
m.addConstr(6*hank + 9*jean + 11*ringo >= 41, "r0_c16")
m.addConstr(5*mary + 9*jean + 11*ringo >= 41, "r0_c17")
m.addConstr(9*jean + 9*peggy + 4*bill >= 41, "r0_c18")
m.addConstr(5*mary**2 + 8*john**2 + 11*ringo**2 >= 54, "r0_c19")
m.addConstr(6*hank + 4*bill + 11*ringo >= 54, "r0_c20")
m.addConstr(6*hank + 9*jean + 11*ringo >= 54, "r0_c21")
m.addConstr(5*mary + 9*jean + 11*ringo >= 54, "r0_c22")
m.addConstr(9*jean + 9*peggy + 4*bill >= 54, "r0_c23")
m.addConstr(5*mary + 8*john + 11*ringo >= 37, "r0_c24")
m.addConstr(6*hank + 4*bill + 11*ringo >= 37, "r0_c25")
m.addConstr(6*hank**2 + 9*jean**2 + 11*ringo**2 >= 37, "r0_c26")
m.addConstr(5*mary**2 + 9*jean**2 + 11*ringo**2 >= 37, "r0_c27")
m.addConstr(9*jean**2 + 9*peggy**2 + 4*bill**2 >= 37, "r0_c28")
m.addConstr(5*mary**2 + 8*john**2 + 11*ringo**2 >= 37, "r0_c29")
m.addConstr(6*hank + 4*bill + 11*ringo >= 37, "r0_c30")
m.addConstr(6*hank + 9*jean + 11*ringo >= 37, "r0_c31")
m.addConstr(5*mary**2 + 9*jean**2 + 11*ringo**2 >= 37, "r0_c32")
m.addConstr(9*jean + 9*peggy + 4*bill >= 37, "r0_c33")
m.addConstr(5*mary**2 + 8*john**2 + 11*ringo**2 >= 38, "r0_c34")
m.addConstr(6*hank + 4*bill + 11*ringo >= 38, "r0_c35")
m.addConstr(6*hank + 9*jean + 11*ringo >= 38, "r0_c36")
m.addConstr(5*mary + 9*jean + 11*ringo >= 38, "r0_c37")
m.addConstr(9*jean**2 + 9*peggy**2 + 4*bill**2 >= 38, "r0_c38")


# Add constraints - Resource r1
m.addConstr(10*john + 6*peggy >= 16, "r1_c1")
m.addConstr(3*jean**2 + ringo**2 >= 10, "r1_c2")
m.addConstr(2*mary + ringo >= 11, "r1_c3")
m.addConstr(4*hank**2 + 6*peggy**2 >= 6, "r1_c4")
m.addConstr(4*hank + 4*dale >= 16, "r1_c5")
m.addConstr(4*hank + ringo >= 6, "r1_c6")
m.addConstr(6*peggy + 4*dale >= 12, "r1_c7")
m.addConstr(10*john + 7*bill >= 8, "r1_c8")
m.addConstr(6*peggy + ringo >= 6, "r1_c9")
m.addConstr(7*bill**2 + 4*dale**2 >= 11, "r1_c10")
m.addConstr(3*jean + 7*bill >= 12, "r1_c11")
m.addConstr(2*mary**2 + 6*peggy**2 >= 13, "r1_c12")
m.addConstr(2*mary**2 + 10*john**2 >= 15, "r1_c13")
m.addConstr(2*mary + 4*hank >= 6, "r1_c14")
m.addConstr(2*mary + 3*jean >= 15, "r1_c15")

# Add constraints - Resource r2
m.addConstr(9*john + 9*ringo >= 15, "r2_c1")
m.addConstr(2*jean + 8*dale >= 13, "r2_c2")
m.addConstr(9*john + 2*peggy >= 14, "r2_c3")
m.addConstr(2*jean + 9*ringo >= 24, "r2_c4")
m.addConstr(9*john + 2*jean >= 12, "r2_c5")
m.addConstr(2*peggy + 8*dale >= 8, "r2_c6")
m.addConstr(5*hank + 8*dale >= 16, "r2_c7")
m.addConstr(2*mary**2 + 2*jean**2 >= 17, "r2_c8")
m.addConstr(2*peggy + 2*bill >= 19, "r2_c9")
m.addConstr(5*hank + 2*peggy >= 15, "r2_c10")
m.addConstr(2*mary + 9*john >= 23, "r2_c11")
m.addConstr(2*jean + 2*peggy >= 22, "r2_c12")
m.addConstr(8*dale + 9*ringo >= 21, "r2_c13")


# Add constraints - Resource r3
m.addConstr(11*mary + 5*ringo <= 292, "r3_c1")
m.addConstr(5*bill + 5*ringo <= 206, "r3_c2")
m.addConstr(4*hank**2 + 2*john**2 <= 160, "r3_c3")
m.addConstr(4*hank + 10*jean <= 285, "r3_c4")
m.addConstr(2*john**2 + 10*jean**2 <= 141, "r3_c5")
m.addConstr(10*jean + 7*dale <= 39, "r3_c6")
m.addConstr(5*bill + 7*dale <= 50, "r3_c7")
m.addConstr(9*peggy**2 + 5*ringo**2 <= 273, "r3_c8")
m.addConstr(11*mary**2 + 7*dale**2 <= 186, "r3_c9")
m.addConstr(11*mary**2 + 10*jean**2 <= 87, "r3_c10")
m.addConstr(10*jean**2 + 5*bill**2 <= 264, "r3_c11")


# Resource 0 upper bound constraints
m.addConstr(5*mary + 9*jean <= 327)
m.addConstr(5*mary + 8*john <= 199)
m.addConstr(8*john**2 + 9*jean**2 <= 162)
m.addConstr(9*peggy + dale <= 355)
m.addConstr(6*hank + dale <= 277)
m.addConstr(4*bill + 11*ringo <= 275)
m.addConstr(9*peggy + 4*bill <= 118)
m.addConstr(6*hank + 4*bill <= 188)
m.addConstr(8*john**2 + 4*bill**2 <= 206)
m.addConstr(5*mary + dale <= 428)
m.addConstr(6*hank + 9*peggy <= 371)
m.addConstr(6*hank + 9*jean <= 125)
m.addConstr(4*bill + dale <= 225)
m.addConstr(8*john**2 + dale**2 <= 311)
m.addConstr(6*hank + 11*ringo <= 207)
m.addConstr(9*jean + 9*peggy <= 219)
m.addConstr(5*mary + 4*bill <= 316)
m.addConstr(5*mary + 9*jean + 4*bill <= 349)
m.addConstr(5*mary + 6*hank + 8*john + 9*jean + 9*peggy + 4*bill + dale + 11*ringo <= 349)


# Resource 1 upper bound constraints
m.addConstr(10*john**2 + 6*peggy**2 <= 56)
m.addConstr(4*hank + 10*john <= 64)
m.addConstr(2*mary + 7*bill <= 128)
m.addConstr(2*mary + ringo <= 87)
m.addConstr(2*mary + 3*jean <= 51)
m.addConstr(4*hank + 3*jean <= 100)
m.addConstr(10*john + 3*jean <= 34)
m.addConstr(2*mary**2 + 4*dale**2 <= 59)
m.addConstr(6*peggy + ringo <= 89)
m.addConstr(3*jean**2 + 6*peggy**2 <= 71)
m.addConstr(2*mary**2 + 10*john**2 <= 33)
m.addConstr(4*hank + 4*dale <= 26)
m.addConstr(3*jean**2 + 7*bill**2 <= 24)
m.addConstr(6*peggy**2 + 4*dale**2 <= 78)
m.addConstr(2*mary**2 + 6*peggy**2 <= 39)
m.addConstr(4*hank + 7*bill <= 113)
m.addConstr(4*dale + ringo <= 38)
m.addConstr(3*jean + ringo <= 106)
m.addConstr(10*john + 4*dale <= 19)
m.addConstr(2*mary + 4*hank <= 54)
m.addConstr(4*hank + 10*john + 4*dale <= 108)
m.addConstr(2*mary + 4*hank + ringo <= 119)
m.addConstr(10*john + 6*peggy + 4*dale <= 120)
m.addConstr(3*jean + 4*dale + ringo <= 77)
m.addConstr(10*john + 4*dale + ringo <= 27)
m.addConstr(4*hank + 10*john + 7*bill <= 18)
m.addConstr(3*jean**2 + 6*peggy**2 + 7*bill**2 <= 25)
m.addConstr(2*mary + 4*hank + 6*peggy <= 102)
m.addConstr(2*mary + 3*jean + 6*peggy <= 38)
m.addConstr(2*mary**2 + 6*peggy**2 + 4*dale**2 <= 78)
m.addConstr(2*mary**2 + 4*hank**2 + 3*jean**2 <= 107)
m.addConstr(4*hank + 10*john + 6*peggy <= 102)
m.addConstr(2*mary + 4*hank + 10*john + 3*jean + 6*peggy + 7*bill + 4*dale + ringo <= 102)


# Resource 2 upper bound constraints
m.addConstr(8*dale**2 + 9*ringo**2 <= 107)
m.addConstr(2*mary**2 + 2*jean**2 <= 160)
m.addConstr(5*hank + 9*john <= 128)
m.addConstr(2*peggy**2 + 8*dale**2 <= 159)
m.addConstr(2*peggy + 2*bill <= 73)
m.addConstr(5*hank + 9*ringo <= 95)
m.addConstr(2*mary**2 + 9*ringo**2 <= 62)
m.addConstr(2*mary + 2*peggy <= 77)
m.addConstr(2*mary + 2*bill <= 177)
m.addConstr(2*bill + 9*ringo <= 151)
m.addConstr(2*jean + 2*peggy <= 70)
m.addConstr(9*john**2 + 2*jean**2 <= 148)
m.addConstr(2*peggy**2 + 9*ringo**2 <= 29)
m.addConstr(2*mary + 5*hank + 9*john + 2*jean + 2*peggy + 2*bill + 8*dale + 9*ringo <= 29)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization was stopped with status %d' % m.status)
    # Compute IIS
    m.computeIIS()
    for c in m.getConstrs():
        if c.IISConstr:
            print('%s' % c.constrName)

