
import gurobipy as gp

# Create a new model
model = gp.Model("Resource_Allocation")

# Create variables
x = model.addVars(5, name=["3D_printers", "staplers", "yellow_highlighters", "red_highlighters", "blue_pens"], vtype=gp.GRB.INTEGER)


# Set objective function
model.setObjective(7.83 * x[0] + 2.22 * x[1] + 6.91 * x[2] + 2.41 * x[3] + 2.49 * x[4], gp.GRB.MAXIMIZE)

# Add constraints
resource_constraints = {
    'r0': {'upper_bound': 180, 'coefficients': [10, 3, 8, 2, 4]},
    'r1': {'upper_bound': 82, 'coefficients': [10, 2, 6, 9, 4]},
    'r2': {'upper_bound': 168, 'coefficients': [9, 9, 1, 5, 4]},
    'r3': {'upper_bound': 239, 'coefficients': [11, 1, 7, 4, 11]}
}

for r, data in resource_constraints.items():
    model.addConstr(gp.quicksum(data['coefficients'][i] * x[i] for i in range(5)) <= data['upper_bound'], name=r)


additional_constraints = [
    (10 * x[0] + 2 * x[3] + 4 * x[4] >= 19),
    (2 * x[1] + 6 * x[2] + 9 * x[3] >= 11),
    (10 * x[0] + 6 * x[2] + 9 * x[3] >= 11),
    (2 * x[1] + 9 * x[3] + 4 * x[4] >= 11),
    (2 * x[1] + 6 * x[2] + 9 * x[3] >= 12),
    (10 * x[0] + 6 * x[2] + 9 * x[3] >= 12),
    (2 * x[1] + 9 * x[3] + 4 * x[4] >= 12),
    (2 * x[1] + 6 * x[2] + 9 * x[3] >= 14),
    (10 * x[0] + 6 * x[2] + 9 * x[3] >= 14),
    (2 * x[1] + 9 * x[3] + 4 * x[4] >= 14),
    (9 * x[0] + x[2] >= 31),
    (9 * x[1] + x[2] + 5 * x[3] >= 16),
    (x[2] + 5 * x[3] + 4 * x[4] >= 16),
    (9 * x[1] + x[2] + 4 * x[4] >= 16),
    (9 * x[0] + 9 * x[1] + x[2] >= 16),
    (9 * x[0] + x[2] + 4 * x[4] >= 16),
    (9 * x[1] + 5 * x[3] + 4 * x[4] >= 16),
    (7 * x[2] + 4 * x[3] + 11 * x[4] >= 27),
    (x[1] + 7 * x[2] + 4 * x[3] >= 27),
    (8 * x[2] + 4 * x[4] <= 98),
    (3 * x[1] + 8 * x[2] <= 143),
    (10 * x[0] + 8 * x[2] <= 169),
    (10 * x[0] + 3 * x[1] + 8 * x[2] <= 84),
    (9 * x[3] + 4 * x[4] <= 45),
    (6 * x[2] + 4 * x[4] <= 38),
    (9 * x[0] + 5 * x[3] <= 110),
    (9 * x[1] + x[2] <= 34),
    (x[1] + 7 * x[2] <= 83)
]

for constraint in additional_constraints:
    model.addConstr(constraint)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}.")

