
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_George")
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Dale")


    # Set objective function
    model.setObjective(7*x0 + 7*x1, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5*x0 + 3*x1 >= 14, "paperwork_competence_min")
    model.addConstr(15*x0 + 9*x1 >= 14, "computer_competence_min")
    model.addConstr(x0 - 7*x1 >= 0, "george_dale_relation")
    model.addConstr(5*x0 + 3*x1 <= 45, "paperwork_competence_max")
    model.addConstr(15*x0 + 9*x1 <= 50, "computer_competence_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    # Print solution if feasible
    elif model.status == gp.GRB.OPTIMAL:
        print("Optimal solution found:")
        print(f"Hours worked by George: {x0.x}")
        print(f"Hours worked by Dale: {x1.x}")
        print(f"Objective value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")

