
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="hours_worked_by_George")
x2 = m.addVar(lb=0, name="hours_worked_by_Dale")

# Set the objective function
m.setObjective(7*x1 + 7*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 3*x2 >= 14, "paperwork_minimum")
m.addConstr(15*x1 + 9*x2 >= 14, "computer_minimum")
m.addConstr(x1 - 7*x2 >= 0, "george_dale_hours")
m.addConstr(5*x1 + 3*x2 <= 45, "paperwork_maximum")
m.addConstr(15*x1 + 9*x2 <= 50, "computer_maximum")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by George: {x1.x}")
    print(f"Hours worked by Dale: {x2.x}")
else:
    print("No optimal solution found.")
