
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_George", lb=0)  # hours worked by George
    x2 = model.addVar(name="hours_worked_by_Dale", lb=0)   # hours worked by Dale

    # Objective function: minimize 7*x1 + 7*x2
    model.setObjective(7*x1 + 7*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5*x1 + 3*x2 >= 14, name="paperwork_rating")  # paperwork competence rating >= 14
    model.addConstr(15*x1 + 9*x2 >= 14, name="computer_rating")  # computer competence rating >= 14
    model.addConstr(x1 - 7*x2 >= 0, name="george_dale_hours")  # 1*x1 - 7*x2 >= 0
    model.addConstr(5*x1 + 3*x2 <= 60, name="paperwork_upper_bound")  # paperwork upper bound
    model.addConstr(15*x1 + 9*x2 <= 64, name="computer_upper_bound")  # computer upper bound

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by George: {x1.varValue}")
        print(f"Hours worked by Dale: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
