
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="reconnaissance_troops")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="pathfinder_teams")


    # Set objective function
    m.setObjective(5*x0 + 7*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(13*x0 + 20*x1 >= 45, "fuel_demand_min")
    m.addConstr(13*x0 + 13*x1 >= 45, "logistical_capacity_min")
    m.addConstr(19*x0 + 15*x1 >= 41, "logistics_footprint_min")
    m.addConstr(1*x0 - 7*x1 >= 0, "x0_x1_relation")
    m.addConstr(13*x0 + 20*x1 <= 58, "fuel_demand_max")
    m.addConstr(13*x0 + 13*x1 <= 94, "logistical_capacity_max")
    m.addConstr(19*x0 + 15*x1 <= 77, "logistics_footprint_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('reconnaissance_troops:', x0.x)
        print('pathfinder_teams:', x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
