
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")
x2 = m.addVar(vtype=GRB.INTEGER, name="pathfinder_teams")

# Set objective function
m.setObjective(5*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13*x1 + 20*x2 >= 45, "fuel_demand_min")
m.addConstr(13*x1 + 13*x2 >= 45, "logistical_capacity_min")
m.addConstr(19*x1 + 15*x2 >= 41, "logistics_footprint_min")
m.addConstr(x1 - 7*x2 >= 0, "troops_relationship")
m.addConstr(13*x1 + 20*x2 <= 58, "fuel_demand_max")
m.addConstr(13*x1 + 13*x2 <= 94, "logistical_capacity_max")
m.addConstr(19*x1 + 15*x2 <= 77, "logistics_footprint_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Reconnaissance troops: {x1.x}")
    print(f"Pathfinder teams: {x2.x}")
else:
    print("No optimal solution found")
