
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='reconnaissance_troops', vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name='pathfinder_teams', vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(5 * x1 + 7 * x2, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(13 * x1 + 20 * x2 >= 45, name='fuel_demand_min')
model.addConstr(13 * x1 + 13 * x2 >= 45, name='logistical_capacity_min')
model.addConstr(19 * x1 + 15 * x2 >= 41, name='logistics_footprint_min')
model.addConstr(x1 - 7 * x2 >= 0, name='troops_to_teams_ratio')
model.addConstr(13 * x1 + 20 * x2 <= 58, name='fuel_demand_max')
model.addConstr(13 * x1 + 13 * x2 <= 94, name='logistical_capacity_max')
model.addConstr(19 * x1 + 15 * x2 <= 77, name='logistics_footprint_max')

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('Reconnaissance troops: ', x1.varValue)
    print('Pathfinder teams: ', x2.varValue)
else:
    print('The problem is infeasible')
