
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="protein_bars")
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="strawberries")


    # Set objective function
    m.setObjective(2*x0 + 4*x1, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(14*x0 + 3*x1 >= 6, "c0")
    m.addConstr(2*x0 + 14*x1 >= 23, "c1")
    m.addConstr(4*x0 + 12*x1 >= 23, "c2")
    m.addConstr(11*x0 + 3*x1 >= 5, "c3")
    m.addConstr(4*x0 - 9*x1 >= 0, "c4")
    m.addConstr(14*x0 + 3*x1 <= 17, "c5")
    m.addConstr(2*x0 + 14*x1 <= 39, "c6")
    m.addConstr(4*x0 + 12*x1 <= 44, "c7")
    m.addConstr(11*x0 + 3*x1 <= 26, "c8")



    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('The problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
