
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Add variables to the model
x0 = model.addVar(vtype=GRB.INTEGER, name="protein_bars")
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="strawberries")

# Set the objective function
model.setObjective(2*x0 + 4*x1, GRB.MAXIMIZE)

# Add constraints to the model
model.addConstr(14*x0 + 3*x1 >= 6, "sourness_index_min")
model.addConstr(14*x0 + 3*x1 <= 17, "sourness_index_max")
model.addConstr(2*x0 + 14*x1 >= 23, "iron_min")
model.addConstr(2*x0 + 14*x1 <= 39, "iron_max")
model.addConstr(4*x0 + 12*x1 >= 23, "calcium_min")
model.addConstr(4*x0 + 12*x1 <= 44, "calcium_max")
model.addConstr(11*x0 + 3*x1 >= 5, "protein_min")
model.addConstr(11*x0 + 3*x1 <= 26, "protein_max")
model.addConstr(4*x0 - 9*x1 >= 0, "additional_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Protein Bars: {x0.x}")
    print(f"Strawberries: {x1.x}")
    print(f"Objective Function Value: {model.objVal}")
else:
    print("No optimal solution found")
