
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="protein_bars", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="strawberries")

    # Define the objective function
    model.setObjective(2 * x0 + 4 * x1, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(14 * x0 + 3 * x1 >= 6, name="sourness_index")
    model.addConstr(2 * x0 + 14 * x1 >= 23, name="iron")
    model.addConstr(4 * x0 + 12 * x1 >= 23, name="calcium")
    model.addConstr(11 * x0 + 3 * x1 >= 5, name="protein")
    model.addConstr(4 * x0 - 9 * x1 >= 0, name="protein_bar_strawberry_ratio")
    model.addConstr(14 * x0 + 3 * x1 <= 17, name="sourness_index_upper_bound")
    model.addConstr(2 * x0 + 14 * x1 <= 39, name="iron_upper_bound")
    model.addConstr(4 * x0 + 12 * x1 <= 44, name="calcium_upper_bound")
    model.addConstr(11 * x0 + 3 * x1 <= 26, name="protein_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Protein bars: {x0.varValue}")
        print(f"Strawberries: {x1.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
