
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(6, lb=0, vtype=gp.GRB.CONTINUOUS, name=["hot dogs", "ham sandwiches", "blueberry pies", "granola bars", "cornichons", "strawberries"])


# Set objective function
m.setObjective(2*x[0]*x[1] + 8*x[0]*x[3] + 8*x[0]*x[4] + 3*x[0]*x[5] + 2*x[1]*x[2] + 9*x[1]*x[3] + 4*x[1]*x[4] + 9*x[2]**2 + 5*x[2]*x[5] + 6*x[3]**2 + 1*x[3]*x[4] + 5*x[3]*x[5] + 7*x[4]**2 + 9*x[4]*x[5] + 5*x[5]**2 + 9*x[1] + 6*x[4] + 3*x[5], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(23*x[0] + 21*x[5] >= 26)
m.addConstr(2*x[3] + 5*x[4] >= 18)
m.addConstr(20*x[2]**2 + 2*x[3]**2 >= 28)
# ... (add all other constraints similarly)
m.addConstr(23*x[0] + 1*x[1] + 20*x[2] + 2*x[3] + 5*x[4] + 21*x[5] <= 244)
m.addConstr(17*x[0] + 19*x[1] + 25*x[2] + 28*x[3] + 25*x[4] + 3*x[5] <= 354)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

