
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="cantaloupes", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="oreos", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="apple_pies", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="kiwis")
x4 = m.addVar(name="bowls_of_instant_ramen")
x5 = m.addVar(name="rotisserie_chickens", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(6.3*x0**2 + 3.48*x0*x1 + 6.25*x0*x4 + 4.34*x0*x5 + 1.08*x1*x2 + 7.63*x1*x3 + 6.66*x2**2 + 6.5*x2*x3 + 7.97*x2*x5 + 4.5*x3**2 + 7.24*x3*x5 + 5.51*x4*x5 + 7.25*x0 + 5.43*x2 + 3.49*x3 + 8.39*x4 + 4.79*x5, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(6*x0 + 9*x1 + 11*x2 + 5*x3 + 10*x4 + 9*x5 <= 381)
m.addConstr(9*x0 + 7*x1 + 11*x2 + 9*x3 + 2*x4 + 4*x5 <= 378)
m.addConstr(8*x0 + 5*x1 + 8*x2 + 4*x3 + 6*x4 + 11*x5 <= 249)
m.addConstr(8*x0 + 9*x1 + 7*x2 + 11*x3 + 7*x4 + 3*x5 <= 168)

# ... Add all constraints similarly

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("cantaloupes: ", x0.x)
    print("oreos: ", x1.x)
    print("apple_pies: ", x2.x)
    print("kiwis: ", x3.x)
    print("bowls_of_instant_ramen: ", x4.x)
    print("rotisserie_chickens: ", x5.x)
else:
    print("No solution found")
