
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    oranges = m.addVar(vtype=gp.GRB.CONTINUOUS, name="oranges")
    bowls_of_cereal = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bowls_of_cereal")


    # Set objective function
    m.setObjective(4.58 * oranges + 4.28 * bowls_of_cereal, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(20 * oranges + 18 * bowls_of_cereal >= 22, "sourness_lower_bound")
    m.addConstr(-3 * oranges + 3 * bowls_of_cereal >= 0, "constraint2")
    m.addConstr(20 * oranges + 18 * bowls_of_cereal <= 33, "sourness_upper_bound")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Oranges: {oranges.x}")
        print(f"Bowls of Cereal: {bowls_of_cereal.x}")
        print(f"Objective Value: {m.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")

