
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(name="oranges", lb=0)  # Assuming non-negativity for amount of oranges
x2 = m.addVar(name="bowls_of_cereal", lb=0)  # Non-negativity for bowls of cereal

# Set the objective function
m.setObjective(4.58*x1 + 4.28*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x1 + 18*x2 >= 22, name="min_sourness")
m.addConstr(-3*x1 + 3*x2 >= 0, name="oranges_vs_cereal")
m.addConstr(20*x1 + 18*x2 <= 33, name="max_sourness")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Oranges: {x1.x}")
    print(f"Bowls of Cereal: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
