
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    oranges = model.addVar(name='oranges', lb=0)  # We assume oranges can be fractional and non-negative
    bowls_of_cereal = model.addVar(name='bowls of cereal', lb=0)  # We assume bowls of cereal can be fractional and non-negative

    # Define the objective function
    model.setObjective(4.58 * oranges + 4.28 * bowls_of_cereal, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(20 * oranges + 18 * bowls_of_cereal >= 22, name='sourness_index_min')
    model.addConstr(20 * oranges + 18 * bowls_of_cereal <= 33, name='sourness_index_max')
    model.addConstr(-3 * oranges + 3 * bowls_of_cereal >= 0, name='balance_constraint')

    # Optimize the model
    model.optimize()

    # Print the status of the model
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Oranges: {oranges.varValue}')
        print(f'Bowls of cereal: {bowls_of_cereal.varValue}')
        print(f'Objective: {model.objVal}')
    elif model.status == gurobi.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('The model has a non-optimal status.')

solve_optimization_problem()
