
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bagged_salads = m.addVar(vtype=gp.GRB.INTEGER, name="x0")
hamburgers = m.addVar(vtype=gp.GRB.INTEGER, name="x1")
bananas = m.addVar(vtype=gp.GRB.INTEGER, name="x2")
protein_bars = m.addVar(vtype=gp.GRB.INTEGER, name="x3")


# Set objective function
m.setObjective(6.71 * bagged_salads + 9.86 * hamburgers + 1.3 * bananas + 8.97 * protein_bars, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(15.89 * bananas + 6.29 * protein_bars >= 65)
m.addConstr(14.62 * bagged_salads + 3.71 * hamburgers >= 39)
m.addConstr(3.71 * hamburgers + 6.29 * protein_bars >= 40)
m.addConstr(14.62 * bagged_salads + 3.71 * hamburgers + 15.89 * bananas >= 44)
m.addConstr(3.71 * hamburgers + 15.89 * bananas + 6.29 * protein_bars >= 44)
m.addConstr(14.62 * bagged_salads + 3.71 * hamburgers + 15.89 * bananas >= 49)
m.addConstr(3.71 * hamburgers + 15.89 * bananas + 6.29 * protein_bars >= 49)
m.addConstr(14.62 * bagged_salads + 3.71 * hamburgers + 15.89 * bananas + 6.29 * protein_bars >= 49)
m.addConstr(5 * bagged_salads - 3 * bananas + 5 * protein_bars >= 0)
m.addConstr(3.71 * hamburgers + 15.89 * bananas <= 197)
m.addConstr(14.62 * bagged_salads + 6.29 * protein_bars <= 143)
m.addConstr(14.62 * bagged_salads + 15.89 * bananas <= 195)
m.addConstr(3.71 * hamburgers + 6.29 * protein_bars <= 285)
m.addConstr(15.89 * bananas + 6.29 * protein_bars <= 281)
m.addConstr(14.62 * bagged_salads + 3.71 * hamburgers + 6.29 * protein_bars <= 157)
m.addConstr(14.62 * bagged_salads + 3.71 * hamburgers + 15.89 * bananas <= 306)
m.addConstr(3.71 * hamburgers + 15.89 * bananas + 6.29 * protein_bars <= 220)
m.addConstr(14.62 * bagged_salads + 3.71 * hamburgers + 15.89 * bananas + 6.29 * protein_bars <= 311)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

