
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="bagged_salads", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="hamburgers", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="bananas", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="protein_bars", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(6.71 * x1 + 9.86 * x2 + 1.3 * x3 + 8.97 * x4, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(15.89 * x3 + 6.29 * x4 >= 65)
    model.addConstr(14.62 * x1 + 3.71 * x2 >= 39)
    model.addConstr(3.71 * x2 + 6.29 * x4 >= 40)
    model.addConstr(14.62 * x1 + 3.71 * x2 + 15.89 * x3 >= 44)
    model.addConstr(3.71 * x2 + 15.89 * x3 + 6.29 * x4 >= 44)
    model.addConstr(14.62 * x1 + 3.71 * x2 + 15.89 * x3 >= 49)
    model.addConstr(3.71 * x2 + 15.89 * x3 + 6.29 * x4 >= 49)
    model.addConstr(14.62 * x1 + 3.71 * x2 + 15.89 * x3 + 6.29 * x4 >= 49)
    model.addConstr(5 * x1 - 3 * x3 + 5 * x4 >= 0)
    model.addConstr(3.71 * x2 + 15.89 * x3 <= 197)
    model.addConstr(14.62 * x1 + 6.29 * x4 <= 143)
    model.addConstr(14.62 * x1 + 15.89 * x3 <= 195)
    model.addConstr(3.71 * x2 + 6.29 * x4 <= 285)
    model.addConstr(15.89 * x3 + 6.29 * x4 <= 281)
    model.addConstr(14.62 * x1 + 3.71 * x2 + 6.29 * x4 <= 157)
    model.addConstr(14.62 * x1 + 3.71 * x2 + 15.89 * x3 <= 306)
    model.addConstr(3.71 * x2 + 15.89 * x3 + 6.29 * x4 <= 220)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("bagged salads: ", x1.varValue)
        print("hamburgers: ", x2.varValue)
        print("bananas: ", x3.varValue)
        print("protein bars: ", x4.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
