
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
foods = ['oreos', 'green beans', 'potatoes', 'cherry pies', 'ravioli', 'rotisserie chickens']
x = m.addVars(foods, lb=0.0, name="x")


# Set objective function
m.setObjective(4*x['oreos'] + x['green beans'] + 4*x['potatoes'] + 8*x['cherry pies'] + 9*x['ravioli'] + 5*x['rotisserie chickens'], gp.GRB.MINIMIZE)

# Protein and tastiness data
protein = {'oreos': 2, 'green beans': 10, 'potatoes': 2, 'cherry pies': 19, 'ravioli': 12, 'rotisserie chickens': 14}
tastiness = {'oreos': 9, 'green beans': 18, 'potatoes': 20, 'cherry pies': 6, 'ravioli': 14, 'rotisserie chickens': 15}

# Add protein constraints
protein_ub = 127
m.addConstr(sum(protein[f] * x[f] for f in foods) <= protein_ub, "protein_ub")


# Add tastiness constraints
tastiness_ub = 123
m.addConstr(sum(tastiness[f] * x[f] for f in foods) <= tastiness_ub, "tastiness_ub")


# Add other constraints from the problem description
constraints = [
    (10*x['green beans'] + 2*x['potatoes'], ">=", 12),
    (2*x['oreos'] + 19*x['cherry pies'], ">=", 11),
    (10*x['green beans'] + 14*x['rotisserie chickens'], ">=", 21),
    (2*x['potatoes'] + 19*x['cherry pies'], ">=", 9),
    (2*x['potatoes'] + 14*x['rotisserie chickens'], ">=", 20),
    (2*x['oreos'] + 12*x['ravioli'] + 14*x['rotisserie chickens'], ">=", 12),
    (2*x['oreos'] + 10*x['green beans'] + 19*x['cherry pies'], ">=", 12),
    # ... (rest of the constraints)
]

for expr, sense, rhs in constraints:
    if sense == ">=":
        m.addConstr(expr >= rhs)
    elif sense == "<=":
        m.addConstr(expr <= rhs)
    elif sense == "=":
        m.addConstr(expr == rhs)

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for f in foods:
        print('%s %g' % (f, x[f].x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

