
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
apples = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apples")
hamburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hamburgers")
bowls_of_pasta = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_pasta")
milkshakes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milkshakes")
granola_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="granola_bars")


# Set objective function
m.setObjective(5*apples**2 + 7*apples*hamburgers + 9*apples*bowls_of_pasta + 7*apples*milkshakes + 9*apples*granola_bars + 8*hamburgers**2 + 2*hamburgers*bowls_of_pasta + 5*hamburgers*milkshakes + 4*hamburgers*granola_bars + 6*bowls_of_pasta**2 + 5*bowls_of_pasta*milkshakes + 4*bowls_of_pasta*granola_bars + 7*milkshakes**2 + 3*milkshakes*granola_bars + 1*granola_bars**2 + 1*apples + 6*hamburgers + 1*bowls_of_pasta + 5*milkshakes + 8*granola_bars, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*milkshakes**2 + granola_bars**2 >= 14)
m.addConstr(4*bowls_of_pasta + 12*granola_bars >= 7)
m.addConstr(8*hamburgers + 12*granola_bars >= 10)
m.addConstr(8*apples + 4*bowls_of_pasta >= 17)
m.addConstr(6*apples**2 + 6*bowls_of_pasta**2 + 13*granola_bars**2 >= 30)
m.addConstr(6*apples**2 + 6*bowls_of_pasta**2 + 11*milkshakes**2 >= 30)
m.addConstr(6*apples + 11*milkshakes + 13*granola_bars >= 30)
m.addConstr(6*apples + 14*hamburgers + 13*granola_bars >= 30)
m.addConstr(6*apples + 6*bowls_of_pasta + 13*granola_bars >= 24)
m.addConstr(6*apples + 6*bowls_of_pasta + 11*milkshakes >= 24)
m.addConstr(6*apples + 11*milkshakes + 13*granola_bars >= 24)
m.addConstr(6*apples + 14*hamburgers + 13*granola_bars >= 24)
m.addConstr(6*apples + 6*bowls_of_pasta + 13*granola_bars >= 29)
m.addConstr(6*apples + 6*bowls_of_pasta + 11*milkshakes >= 29)
m.addConstr(6*apples**2 + 11*milkshakes**2 + 13*granola_bars**2 >= 29)
m.addConstr(6*apples**2 + 14*hamburgers**2 + 13*granola_bars**2 >= 29)
m.addConstr(6*apples**2 + 6*bowls_of_pasta**2 + 13*granola_bars**2 >= 23)
m.addConstr(6*apples**2 + 6*bowls_of_pasta**2 + 11*milkshakes**2 >= 23)
m.addConstr(6*apples**2 + 11*milkshakes**2 + 13*granola_bars**2 >= 23)
m.addConstr(6*apples**2 + 14*hamburgers**2 + 13*granola_bars**2 >= 23)
m.addConstr(3*hamburgers + granola_bars >= 43)
m.addConstr(8*apples + 4*bowls_of_pasta <= 98)
m.addConstr(8*apples + 5*milkshakes <= 71)
m.addConstr(8*hamburgers + 12*granola_bars <= 30)
m.addConstr(4*bowls_of_pasta + 5*milkshakes + 12*granola_bars <= 87)
m.addConstr(8*apples + 4*bowls_of_pasta + 5*milkshakes <= 109)
m.addConstr(8*hamburgers + 5*milkshakes + 12*granola_bars <= 85)
m.addConstr(8*hamburgers + 4*bowls_of_pasta + 12*granola_bars <= 59)
m.addConstr(8*hamburgers**2 + 4*bowls_of_pasta**2 + 5*milkshakes**2 <= 35)
m.addConstr(8*apples**2 + 8*hamburgers**2 + 5*milkshakes**2 <= 52)
m.addConstr(8*apples + 8*hamburgers + 4*bowls_of_pasta <= 86)
m.addConstr(8*apples**2 + 4*bowls_of_pasta**2 + 12*granola_bars**2 <= 42)
m.addConstr(8*apples + 8*hamburgers + 4*bowls_of_pasta + 5*milkshakes + 12*granola_bars <= 42)
m.addConstr(6*bowls_of_pasta + 11*milkshakes <= 70)
m.addConstr(6*apples**2 + 6*bowls_of_pasta**2 <= 102)
m.addConstr(6*apples + 14*hamburgers + 6*bowls_of_pasta <= 134)
m.addConstr(14*hamburgers**2 + 6*bowls_of_pasta**2 + 13*granola_bars**2 <= 123)
m.addConstr(14*hamburgers + 6*bowls_of_pasta + 11*milkshakes <= 82)
m.addConstr(6*apples + 14*hamburgers + 6*bowls_of_pasta + 11*milkshakes + 13*granola_bars <= 82)
m.addConstr(3*apples + 3*hamburgers <= 62)
m.addConstr(3*apples + 11*milkshakes <= 139)
m.addConstr(2*bowls_of_pasta + granola_bars <= 132)
m.addConstr(3*hamburgers**2 + 2*bowls_of_pasta**2 <= 205)
m.addConstr(3*apples + granola_bars <= 57)
m.addConstr(3*apples + 2*bowls_of_pasta <= 105)
m.addConstr(3*hamburgers + 2*bowls_of_pasta + granola_bars <= 156)
m.addConstr(3*apples + 3*hamburgers + 2*bowls_of_pasta + 11*milkshakes + granola_bars <= 156)


m.addConstr(8*apples + 8*hamburgers + 4*bowls_of_pasta + 5*milkshakes + 12*granola_bars <= 112)
m.addConstr(6*apples + 14*hamburgers + 6*bowls_of_pasta + 11*milkshakes + 13*granola_bars <= 157)
m.addConstr(3*apples + 3*hamburgers + 2*bowls_of_pasta + 11*milkshakes + granola_bars <= 242)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

