
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bobby = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
jean = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
laura = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")


# Set objective function
m.setObjective(8.66 * bobby + 6.28 * hank + 1.06 * jean + 4.68 * laura, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(13 * hank + 9 * jean + 1 * laura >= 13, "c1")
m.addConstr(2 * bobby + 13 * hank + 9 * jean + 1 * laura >= 13, "c2")
m.addConstr(13 * bobby + 5 * jean >= 28, "c3")
m.addConstr(4 * hank + 1 * laura >= 21, "c4")
m.addConstr(5 * jean + 1 * laura >= 20, "c5")
m.addConstr(13 * bobby + 4 * hank >= 28, "c6")
m.addConstr(4 * hank + 5 * jean + 1 * laura >= 23, "c7")
m.addConstr(13 * bobby + 4 * hank + 5 * jean + 1 * laura >= 23, "c8")
m.addConstr(10 * jean + 12 * laura >= 17, "c9")
m.addConstr(5 * bobby + 10 * jean >= 15, "c10")
m.addConstr(5 * bobby + 10 * hank + 10 * jean + 12 * laura >= 15, "c11")
m.addConstr(4 * hank - 2 * jean >= 0, "c12")
m.addConstr(2 * bobby + 9 * jean <= 51, "c13")
m.addConstr(4 * hank + 5 * jean <= 61, "c14")
m.addConstr(5 * jean + 1 * laura <= 98, "c15")
m.addConstr(13 * bobby + 5 * jean <= 64, "c16")
m.addConstr(13 * bobby + 4 * hank + 1 * laura <= 77, "c17")
m.addConstr(4 * hank + 5 * jean + 1 * laura <= 91, "c18")
m.addConstr(5 * bobby + 12 * laura <= 81, "c19")
m.addConstr(10 * hank + 10 * jean <= 74, "c20")
m.addConstr(10 * hank + 12 * laura <= 60, "c21")
m.addConstr(10 * jean + 12 * laura <= 77, "c22")
m.addConstr(5 * bobby + 10 * hank + 12 * laura <= 70, "c23")
m.addConstr(5 * bobby + 10 * hank + 10 * jean <= 43, "c24")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

