
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=-gurobi.GRB.INFINITY)  # hours worked by Bobby
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY)  # hours worked by Hank
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY)  # hours worked by Jean
    x3 = model.addVar(name="x3", lb=-gurobi.GRB.INFINITY)  # hours worked by Laura

    # Objective function
    model.setObjective(8.66 * x0 + 6.28 * x1 + 1.06 * x2 + 4.68 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(13 * x1 + 9 * x2 + x3 >= 13)
    model.addConstr(2 * x0 + 13 * x1 + 9 * x2 + x3 >= 13)
    model.addConstr(13 * x0 + 5 * x2 >= 28)
    model.addConstr(4 * x1 + x3 >= 21)
    model.addConstr(5 * x2 + x3 >= 20)
    model.addConstr(13 * x0 + 4 * x1 >= 28)
    model.addConstr(4 * x1 + 5 * x2 + x3 >= 23)
    model.addConstr(13 * x0 + 4 * x1 + 5 * x2 + x3 >= 23)
    model.addConstr(10 * x2 + 12 * x3 >= 17)
    model.addConstr(5 * x0 + 10 * x2 >= 15)
    model.addConstr(5 * x0 + 10 * x1 + 10 * x2 + 12 * x3 >= 15)
    model.addConstr(4 * x1 - 2 * x2 >= 0)
    model.addConstr(2 * x0 + 9 * x2 <= 51)
    model.addConstr(4 * x1 + 5 * x2 <= 61)
    model.addConstr(5 * x2 + x3 <= 98)
    model.addConstr(13 * x0 + 5 * x2 <= 64)
    model.addConstr(13 * x0 + 4 * x1 + x3 <= 77)
    model.addConstr(4 * x1 + 5 * x2 + x3 <= 91)
    model.addConstr(5 * x0 + 12 * x3 <= 81)
    model.addConstr(10 * x1 + 10 * x2 <= 74)
    model.addConstr(10 * x1 + 12 * x3 <= 60)
    model.addConstr(10 * x2 + 12 * x3 <= 77)
    model.addConstr(5 * x0 + 10 * x1 + 12 * x3 <= 70)
    model.addConstr(5 * x0 + 10 * x1 + 10 * x2 <= 43)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Bobby: ", x0.varValue)
        print("Hours worked by Hank: ", x1.varValue)
        print("Hours worked by Jean: ", x2.varValue)
        print("Hours worked by Laura: ", x3.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
