
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimize_work_hours")

    # Create variables
    laura_hours = m.addVar(vtype=gp.GRB.INTEGER, name="laura_hours")
    mary_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="mary_hours")
    ringo_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="ringo_hours")

    # Set objective function
    m.setObjective(8 * laura_hours + 6 * mary_hours + 5 * ringo_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4 * laura_hours + 3 * ringo_hours >= 12, "c1")
    m.addConstr(4 * laura_hours + 11 * mary_hours <= 36, "c2")
    m.addConstr(11 * mary_hours + 3 * ringo_hours <= 47, "c3")
    m.addConstr(4 * laura_hours + 11 * mary_hours + 3 * ringo_hours <= 47, "c4")
    m.addConstr(6 * mary_hours + 8 * ringo_hours <= 48, "c5")
    m.addConstr(3 * laura_hours + 8 * ringo_hours <= 60, "c6")
    m.addConstr(3 * laura_hours + 6 * mary_hours + 8 * ringo_hours <= 25, "c7")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Laura Hours: %g' % laura_hours.x)
        print('Mary Hours: %g' % mary_hours.x)
        print('Ringo Hours: %g' % ringo_hours.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
