
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Laura
    x1 = model.addVar(name="x1")  # hours worked by Mary
    x2 = model.addVar(name="x2")  # hours worked by Ringo

    # Objective function
    model.setObjective(8*x0 + 6*x1 + 5*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4*x0 + 3*x2 >= 12)
    model.addConstr(4*x0 + 11*x1 <= 36)
    model.addConstr(11*x1 + 3*x2 <= 47)
    model.addConstr(4*x0 + 11*x1 + 3*x2 <= 47)
    model.addConstr(6*x1 + 8*x2 <= 48)
    model.addConstr(3*x0 + 8*x2 <= 60)
    model.addConstr(3*x0 + 6*x1 + 8*x2 <= 25)
    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Laura: ", x0.varValue)
        print("Hours worked by Mary: ", x1.varValue)
        print("Hours worked by Ringo: ", x2.varValue)
    else:
        print("The problem is infeasible")

solve_optimization_problem()
