
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Mary")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_George")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Bill")


    # Set objective function
    m.setObjective(7.08 * x0 + 2.43 * x1 + 4.45 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(15 * x0 + 12 * x2 >= 38, "c0")
    m.addConstr(15 * x0 + 4 * x1 + 12 * x2 >= 53, "c1")
    m.addConstr(6 * x0 + 4 * x2 >= 28, "c2")
    m.addConstr(6 * x0 + 8 * x1 + 4 * x2 >= 29, "c3")
    m.addConstr(4 * x1 + 12 * x2 <= 156, "c4")
    m.addConstr(15 * x0 + 4 * x1 + 12 * x2 <= 156, "c5")
    m.addConstr(2 * x0 + 10 * x2 <= 66, "c6")
    m.addConstr(2 * x0 + 6 * x1 + 10 * x2 <= 92, "c7")
    m.addConstr(7 * x0 + 6 * x2 <= 100, "c8")
    m.addConstr(7 * x0 + 12 * x1 + 6 * x2 <= 100, "c9")
    m.addConstr(8 * x1 + 4 * x2 <= 33, "c10")
    m.addConstr(6 * x0 + 8 * x1 + 4 * x2 <= 33, "c11")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
