
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="hours_worked_by_Mary", lb=0)
x1 = model.addVar(name="hours_worked_by_George", lb=0)
x2 = model.addVar(name="hours_worked_by_Bill", lb=0)

# Define the objective function
model.setObjective(7.08 * x0 + 2.43 * x1 + 4.45 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(15 * x0 <= 159)
model.addConstr(2 * x0 <= 103)
model.addConstr(7 * x0 <= 128)
model.addConstr(6 * x0 <= 97)
model.addConstr(4 * x1 <= 159)
model.addConstr(6 * x1 <= 103)
model.addConstr(12 * x1 <= 128)
model.addConstr(8 * x1 <= 97)
model.addConstr(12 * x2 <= 159)
model.addConstr(10 * x2 <= 103)
model.addConstr(6 * x2 <= 128)
model.addConstr(4 * x2 <= 97)
model.addConstr(15 * x0 + 12 * x2 >= 38)
model.addConstr(15 * x0 + 4 * x1 + 12 * x2 >= 53)
model.addConstr(6 * x0 + 4 * x2 >= 28)
model.addConstr(6 * x0 + 8 * x1 + 4 * x2 >= 29)
model.addConstr(4 * x1 + 12 * x2 <= 156)
model.addConstr(15 * x0 + 4 * x1 + 12 * x2 <= 156)
model.addConstr(2 * x0 + 10 * x2 <= 66)
model.addConstr(2 * x0 + 6 * x1 + 10 * x2 <= 92)
model.addConstr(7 * x0 + 6 * x2 <= 100)
model.addConstr(7 * x0 + 12 * x1 + 6 * x2 <= 100)
model.addConstr(8 * x1 + 4 * x2 <= 33)
model.addConstr(6 * x0 + 8 * x1 + 4 * x2 <= 33)

# Optimize the model
model.optimize()

# Print the solution
print("Objective: ", model.objVal)
print("Hours worked by Mary: ", x0.varValue)
print("Hours worked by George: ", x1.varValue)
print("Hours worked by Bill: ", x2.varValue)

# Symbolic representation
sym_variables = [('x0', 'hours worked by Mary'), ('x1', 'hours worked by George'), ('x2', 'hours worked by Bill')]
objective_function = '7.08*x0 + 2.43*x1 + 4.45*x2'
constraints = [
    '15*x0 <= 159',
    '2*x0 <= 103',
    '7*x0 <= 128',
    '6*x0 <= 97',
    '4*x1 <= 159',
    '6*x1 <= 103',
    '12*x1 <= 128',
    '8*x1 <= 97',
    '12*x2 <= 159',
    '10*x2 <= 103',
    '6*x2 <= 128',
    '4*x2 <= 97',
    '15*x0 + 12*x2 >= 38',
    '15*x0 + 4*x1 + 12*x2 >= 53',
    '6*x0 + 4*x2 >= 28',
    '6*x0 + 8*x1 + 4*x2 >= 29',
    '4*x1 + 12*x2 <= 156',
    '15*x0 + 4*x1 + 12*x2 <= 156',
    '2*x0 + 10*x2 <= 66',
    '2*x0 + 6*x1 + 10*x2 <= 92',
    '7*x0 + 6*x2 <= 100',
    '7*x0 + 12*x1 + 6*x2 <= 100',
    '8*x1 + 4*x2 <= 33',
    '6*x0 + 8*x1 + 4*x2 <= 33'
]

print("\nSymbolic Representation:")
print("Variables: ", sym_variables)
print("Objective Function: ", objective_function)
print("Constraints: ", constraints)
