
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x = model.addVars(4, vtype=gp.GRB.INTEGER, name=["Bill", "Mary", "Ringo", "Jean"])


    # Set objective function
    model.setObjective(7.97 * x[0] + 6.79 * x[1] + 5.42 * x[2] + 2.69 * x[3], gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6 * x[0] + 9 * x[2] >= 26, "c0")
    model.addConstr(6 * x[0] + 10 * x[3] >= 30, "c1")
    model.addConstr(8 * x[1] + 9 * x[2] >= 30, "c2")
    model.addConstr(6 * x[0] + 8 * x[1] >= 37, "c3")
    model.addConstr(9 * x[2] + 10 * x[3] >= 25, "c4")
    model.addConstr(6 * x[0] + 8 * x[1] + 9 * x[2] >= 31, "c5")
    model.addConstr(6 * x[0] + 8 * x[1] + 9 * x[2] + 10 * x[3] >= 31, "c6")
    model.addConstr(3 * x[1] + 10 * x[3] >= 17, "c7")
    model.addConstr(3 * x[1] + 4 * x[2] >= 33, "c8")
    model.addConstr(8 * x[0] + 10 * x[3] >= 12, "c9")
    model.addConstr(8 * x[0] + 4 * x[2] >= 29, "c10")
    model.addConstr(8 * x[0] + 3 * x[1] + 4 * x[2] + 10 * x[3] >= 29, "c11")
    model.addConstr(8 * x[0] + 3 * x[1] <= 83, "c12")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % model.objVal)
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
