
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Bill
x1 = m.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Mary
x2 = m.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo
x3 = m.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # hours worked by Jean

# Define the objective function
m.setObjective(7.97 * x0 + 6.79 * x1 + 5.42 * x2 + 2.69 * x3, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * x0 <= 194, name="r0_x0")
m.addConstr(8 * x0 <= 145, name="r1_x0")
m.addConstr(8 * x1 <= 194, name="r0_x1")
m.addConstr(3 * x1 <= 145, name="r1_x1")
m.addConstr(9 * x2 <= 194, name="r0_x2")
m.addConstr(4 * x2 <= 145, name="r1_x2")
m.addConstr(10 * x3 <= 194, name="r0_x3")
m.addConstr(10 * x3 <= 145, name="r1_x3")

m.addConstr(6 * x0 + 9 * x2 >= 26, name="combined_r0_x0_x2")
m.addConstr(6 * x0 + 10 * x3 >= 30, name="combined_r0_x0_x3")
m.addConstr(8 * x1 + 9 * x2 >= 30, name="combined_r0_x1_x2")
m.addConstr(6 * x0 + 8 * x1 >= 37, name="combined_r0_x0_x1")
m.addConstr(9 * x2 + 10 * x3 >= 25, name="combined_r0_x2_x3")
m.addConstr(6 * x0 + 8 * x1 + 9 * x2 >= 31, name="combined_r0_x0_x1_x2")
m.addConstr(6 * x0 + 8 * x1 + 9 * x2 + 10 * x3 >= 31, name="combined_r0_x0_x1_x2_x3")

m.addConstr(3 * x1 + 10 * x3 >= 17, name="combined_r1_x1_x3")
m.addConstr(3 * x1 + 4 * x2 >= 33, name="combined_r1_x1_x2")
m.addConstr(8 * x0 + 10 * x3 >= 12, name="combined_r1_x0_x3")
m.addConstr(8 * x0 + 4 * x2 >= 29, name="combined_r1_x0_x2")
m.addConstr(8 * x0 + 3 * x1 + 4 * x2 + 10 * x3 >= 29, name="combined_r1_x0_x1_x2_x3")
m.addConstr(8 * x0 + 3 * x1 <= 83, name="combined_r1_x0_x1")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bill: ", x0.varValue)
    print("Hours worked by Mary: ", x1.varValue)
    print("Hours worked by Ringo: ", x2.varValue)
    print("Hours worked by Jean: ", x3.varValue)
else:
    print("The model is infeasible")
