
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of magnesium
    x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x1")  # milligrams of vitamin B12
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # grams of protein
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")  # milligrams of vitamin E


    # Set objective function
    m.setObjective(5*x0**2 + 5*x1*x2 + 7*x1*x3 + 8*x2*x3 + 8*x3**2 + 6*x1 + 5*x2 + 5*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4*x0 + 9*x1 + 14*x2 + 6*x3 >= 28)
    m.addConstr(4*x0**2 + 9*x1**2 >= 42)
    m.addConstr(9*x1**2 + 14*x2**2 >= 62)
    m.addConstr(4*x0 + 9*x1 + 6*x3 >= 59)
    m.addConstr(4*x0 + 14*x2 + 6*x3 >= 59)
    m.addConstr(4*x0**2 + 9*x1**2 + 6*x3**2 >= 46)
    m.addConstr(4*x0 + 14*x2 + 6*x3 >= 46)
    m.addConstr(5*x2 + 4*x3 <= 33)
    m.addConstr(2*x1 + 5*x2 <= 60)
    m.addConstr(x0**2 + 5*x2**2 <= 52)
    m.addConstr(2*x1**2 + 4*x3**2 <= 42)
    m.addConstr(x0 + 2*x1 + 5*x2 + 4*x3 <= 42)
    m.addConstr(4*x0**2 + 9*x1**2 <= 141)
    m.addConstr(9*x1 + 14*x2 <= 112)
    m.addConstr(14*x2 + 6*x3 <= 155)
    m.addConstr(4*x0**2 + 14*x2**2 <= 69)
    m.addConstr(9*x1 + 6*x3 <= 92)
    m.addConstr(4*x0 + 9*x1 + 14*x2 + 6*x3 <= 92)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
