
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(lb=0, name="milligrams of magnesium")
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="milligrams of vitamin B12")
x2 = m.addVar(lb=0, name="grams of protein")
x3 = m.addVar(lb=0, name="milligrams of vitamin E")

# Define the objective function
m.setObjective(5*x0**2 + 5*x1*x2 + 7*x1*x3 + 8*x2*x3 + 8*x3**2 + 6*x1 + 5*x2 + 5*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x0 <= 63)
m.addConstr(4*x0 + 9*x1 + 14*x2 + 6*x3 <= 248)
m.addConstr(x0 + 2*x1 + 5*x2 + 4*x3 <= 63)
m.addConstr(14*x2 + 6*x3 >= 28)
m.addConstr(4*x0**2 + 9*x1**2 >= 42)
m.addConstr(9*x1**2 + 196*x2**2 >= 62)
m.addConstr(4*x0 + 9*x1 + 6*x3 >= 59)
m.addConstr(4*x0 + 14*x2 + 6*x3 >= 59)
m.addConstr(16*x0**2 + 81*x1**2 + 36*x3**2 >= 46)
m.addConstr(4*x0 + 14*x2 + 6*x3 >= 46)
m.addConstr(5*x2 + 4*x3 <= 33)
m.addConstr(2*x1 + 5*x2 <= 60)
m.addConstr(x0**2 + 25*x2**2 <= 52)
m.addConstr(81*x1**2 + 36*x3**2 <= 42)
m.addConstr(x0 + 2*x1 + 5*x2 + 4*x3 <= 42)
m.addConstr(16*x0**2 + 81*x1**2 <= 141)
m.addConstr(9*x1 + 14*x2 <= 112)
m.addConstr(14*x2 + 6*x3 <= 155)
m.addConstr(16*x0**2 + 196*x2**2 <= 69)
m.addConstr(9*x1 + 6*x3 <= 92)
m.addConstr(4*x0 + 9*x1 + 14*x2 + 6*x3 <= 92)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("milligrams of magnesium:", x0.varValue)
    print("milligrams of vitamin B12:", x1.varValue)
    print("grams of protein:", x2.varValue)
    print("milligrams of vitamin E:", x3.varValue)
else:
    print("No optimal solution found.")
