
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
apple_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")
green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")
granola_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="granola_bars")
oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")


# Set objective function
m.setObjective(2*apple_pies + 9*green_beans + 2*granola_bars + 4*oreos, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*granola_bars + 4*oreos >= 7)
m.addConstr(9*green_beans + 4*granola_bars >= 6)
m.addConstr(5*apple_pies + 6*granola_bars + 6*oreos >= 14)
m.addConstr(5*apple_pies + 4*green_beans + 6*oreos >= 14)
m.addConstr(5*apple_pies + 4*green_beans + 6*granola_bars >= 14)
m.addConstr(5*apple_pies + 6*granola_bars + 6*oreos >= 13)
m.addConstr(5*apple_pies + 4*green_beans + 6*oreos >= 13)
m.addConstr(5*apple_pies + 4*green_beans + 6*granola_bars >= 13)
m.addConstr(5*apple_pies + 6*granola_bars + 6*oreos >= 11)
m.addConstr(5*apple_pies + 4*green_beans + 6*oreos >= 11)
m.addConstr(5*apple_pies + 4*green_beans + 6*granola_bars >= 11)
m.addConstr(9*apple_pies + 7*oreos >= 8)
m.addConstr(6*green_beans + 7*oreos >= 17)
m.addConstr(6*green_beans + 3*granola_bars >= 10)
m.addConstr(9*apple_pies + 3*granola_bars >= 16)
m.addConstr(6*green_beans - 5*granola_bars >= 0)
m.addConstr(4*granola_bars + 4*oreos <= 20)
m.addConstr(5*apple_pies + 9*green_beans <= 36)
m.addConstr(5*apple_pies + 4*oreos <= 63)
m.addConstr(9*green_beans + 4*oreos <= 35)
m.addConstr(5*apple_pies + 4*granola_bars <= 57)
m.addConstr(5*apple_pies + 4*granola_bars + 4*oreos <= 64)
m.addConstr(5*apple_pies + 9*green_beans + 4*granola_bars + 4*oreos <= 64)
m.addConstr(6*granola_bars + 6*oreos <= 61)
m.addConstr(4*green_beans + 6*oreos <= 65)
m.addConstr(5*apple_pies + 6*oreos <= 75)
m.addConstr(5*apple_pies + 4*green_beans + 6*granola_bars + 6*oreos <= 75)
m.addConstr(9*apple_pies + 3*granola_bars <= 37)
m.addConstr(3*granola_bars + 7*oreos <= 23)
m.addConstr(9*apple_pies + 6*green_beans <= 71)
m.addConstr(6*green_beans + 7*oreos <= 33)
m.addConstr(6*green_beans + 3*granola_bars <= 78)
m.addConstr(9*apple_pies + 6*green_beans + 3*granola_bars + 7*oreos <= 78)

m.addConstr(5*apple_pies <= 76)
m.addConstr(5*apple_pies + 4*green_beans + 6*granola_bars + 6*oreos <= 81)
m.addConstr(9*apple_pies + 6*green_beans + 3*granola_bars + 7*oreos <= 83)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

