
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="apple_pies", lb=0)
x1 = m.addVar(name="green_beans", lb=0)
x2 = m.addVar(name="granola_bars", lb=0)
x3 = m.addVar(name="oreos", lb=0)

# Define the objective function
m.setObjective(2*x0 + 9*x1 + 2*x2 + 4*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x0 + 9*x1 + 4*x2 + 4*x3 <= 76)
m.addConstr(5*x0 + 4*x1 + 6*x2 + 6*x3 <= 81)
m.addConstr(9*x0 + 6*x1 + 3*x2 + 7*x3 <= 83)
m.addConstr(4*x2 + 4*x3 >= 7)
m.addConstr(9*x1 + 4*x2 >= 6)
m.addConstr(5*x0 + 6*x2 + 6*x3 >= 14)
m.addConstr(5*x0 + 4*x1 + 6*x3 >= 14)
m.addConstr(5*x0 + 4*x1 + 6*x2 >= 14)
m.addConstr(5*x0 + 6*x2 + 6*x3 >= 13)
m.addConstr(5*x0 + 4*x1 + 6*x3 >= 13)
m.addConstr(5*x0 + 4*x1 + 6*x2 >= 13)
m.addConstr(5*x0 + 6*x2 + 6*x3 >= 11)
m.addConstr(5*x0 + 4*x1 + 6*x3 >= 11)
m.addConstr(5*x0 + 4*x1 + 6*x2 >= 11)
m.addConstr(9*x0 + 7*x3 >= 8)
m.addConstr(6*x1 + 7*x3 >= 17)
m.addConstr(6*x1 + 3*x2 >= 10)
m.addConstr(9*x0 + 3*x2 >= 16)
m.addConstr(6*x1 - 5*x2 >= 0)
m.addConstr(4*x2 + 4*x3 <= 20)
m.addConstr(5*x0 + 9*x1 <= 36)
m.addConstr(5*x0 + 4*x3 <= 63)
m.addConstr(9*x1 + 4*x3 <= 35)
m.addConstr(5*x0 + 4*x2 <= 57)
m.addConstr(5*x0 + 4*x2 + 4*x3 <= 64)
m.addConstr(5*x0 + 9*x1 + 4*x2 + 4*x3 <= 64)
m.addConstr(6*x2 + 6*x3 <= 61)
m.addConstr(4*x1 + 6*x3 <= 65)
m.addConstr(5*x0 + 6*x3 <= 75)
m.addConstr(5*x0 + 4*x1 + 6*x2 + 6*x3 <= 75)
m.addConstr(9*x0 + 3*x2 <= 37)
m.addConstr(3*x2 + 7*x3 <= 23)
m.addConstr(9*x0 + 6*x1 <= 71)
m.addConstr(6*x1 + 7*x3 <= 33)
m.addConstr(6*x1 + 3*x2 <= 78)
m.addConstr(9*x0 + 6*x1 + 3*x2 + 7*x3 <= 78)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Apple Pies: ", x0.varValue)
    print("Green Beans: ", x1.varValue)
    print("Granola Bars: ", x2.varValue)
    print("Oreos: ", x3.varValue)
else:
    print("The model is infeasible")
