
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("military_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="airborne_infantry_companies")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="reconnaissance_troops")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="medical_platoons")
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="military_intelligence_companies")

    # Set objective function
    m.setObjective(8.45 * x0 + 6.05 * x1 + 1.68 * x2 + 9.56 * x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4.55 * x0 + 9.92 * x1 + 1.03 * x2 + 8.91 * x3 <= 135, "c0")
    m.addConstr(4.55 * x0 + 1.03 * x2 >= 19, "c1")
    m.addConstr(9.92 * x1 + 8.91 * x3 >= 14, "c2")
    m.addConstr(9.92 * x1 + 1.03 * x2 >= 29, "c3")
    m.addConstr(4.55 * x0 + 8.91 * x3 >= 22, "c4")
    m.addConstr(1.03 * x2 + 8.91 * x3 >= 25, "c5")
    m.addConstr(9.92 * x1 + 1.03 * x2 + 8.91 * x3 >= 32, "c6")
    m.addConstr(9.92 * x1 + 1.03 * x2 <= 71, "c7")
    m.addConstr(4.55 * x0 + 8.91 * x3 <= 37, "c8")
    m.addConstr(1.03 * x2 + 8.91 * x3 <= 129, "c9")
    m.addConstr(4.55 * x0 + 1.03 * x2 + 8.91 * x3 <= 68, "c10")
    m.addConstr(4.55 * x0 + 9.92 * x1 + 1.03 * x2 + 8.91 * x3 <= 68, "c11")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
