
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='airborne_infantry_companies', vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name='reconnaissance_troops', vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(name='medical_platoons', vtype=gurobi.GRB.INTEGER)
x4 = model.addVar(name='military_intelligence_companies', vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(8.45 * x1 + 6.05 * x2 + 1.68 * x3 + 9.56 * x4, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4.55 * x1 + 1.03 * x3 >= 19)
model.addConstr(9.92 * x2 + 8.91 * x4 >= 14)
model.addConstr(9.92 * x2 + 1.03 * x3 >= 29)
model.addConstr(4.55 * x1 + 8.91 * x4 >= 22)
model.addConstr(1.03 * x3 + 8.91 * x4 >= 25)
model.addConstr(9.92 * x2 + 1.03 * x3 + 8.91 * x4 >= 32)
model.addConstr(9.92 * x2 + 1.03 * x3 <= 71)
model.addConstr(4.55 * x1 + 8.91 * x4 <= 37)
model.addConstr(1.03 * x3 + 8.91 * x4 <= 129)
model.addConstr(4.55 * x1 + 1.03 * x3 + 8.91 * x4 <= 68)
model.addConstr(4.55 * x1 + 9.92 * x2 + 1.03 * x3 + 8.91 * x4 <= 68)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('Airborne Infantry Companies: ', x1.varValue)
    print('Reconnaissance Troops: ', x2.varValue)
    print('Medical Platoons: ', x3.varValue)
    print('Military Intelligence Companies: ', x4.varValue)
else:
    print('The model is infeasible')
