
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
iron = m.addVar(name="iron")
vitamin_b6 = m.addVar(name="vitamin_b6")
fat = m.addVar(name="fat")

# Set objective function
m.setObjective(7.62 * iron + 3.72 * vitamin_b6 + 1.4 * fat, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(15 * iron + 32 * fat <= 186, "c1")
m.addConstr(24 * vitamin_b6 + 32 * fat <= 218, "c2")
m.addConstr(15 * iron + 24 * vitamin_b6 + 32 * fat <= 218, "c3")
m.addConstr(-7 * iron + 2 * fat >= 0, "c4")


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Iron: %g' % iron.x)
    print('Vitamin B6: %g' % vitamin_b6.x)
    print('Fat: %g' % fat.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

