
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, name="milligrams_of_iron")
x2 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, name="milligrams_of_vitamin_B6")
x3 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, name="grams_of_fat")

# Define the objective function
m.setObjective(7.62*x1 + 3.72*x2 + 1.4*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(-7*x1 + 2*x3 >= 0, name="constraint_1")
m.addConstr(15*x1 + 32*x3 <= 186, name="constraint_2")
m.addConstr(24*x2 + 32*x3 <= 218, name="constraint_3")
m.addConstr(15*x1 + 24*x2 + 32*x3 <= 218, name="constraint_4")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"milligrams_of_iron: {x1.x}")
    print(f"milligrams_of_vitamin_B6: {x2.x}")
    print(f"grams_of_fat: {x3.x}")
else:
    print("No optimal solution found.")
