
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_iron", lb=0)  # No lower bound specified
    x2 = model.addVar(name="milligrams_of_vitamin_B6", lb=0)  # No lower bound specified
    x3 = model.addVar(name="grams_of_fat", lb=0)  # No lower bound specified

    # Define the objective function
    model.setObjective(7.62 * x1 + 3.72 * x2 + 1.4 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(-7 * x1 + 2 * x3 >= 0, name="constraint_1")
    model.addConstr(15 * x1 + 32 * x3 <= 186, name="constraint_2")
    model.addConstr(24 * x2 + 32 * x3 <= 218, name="constraint_3")
    model.addConstr(15 * x1 + 24 * x2 + 32 * x3 <= 218, name="constraint_4")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of iron: {x1.varValue}")
        print(f"Milligrams of vitamin B6: {x2.varValue}")
        print(f"Grams of fat: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
