
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
bobby = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bobby")

# Set objective function
m.setObjective(3.19 * hank + 1.64 * ringo + 2.01 * dale + 2.72 * bobby, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * hank + 15 * ringo >= 26)
m.addConstr(15 * ringo + 1 * dale >= 30)
m.addConstr(2 * hank + 1 * dale >= 10)
m.addConstr(2 * hank + 16 * bobby >= 21)
m.addConstr(2 * hank + 15 * ringo + 1 * dale >= 18)
m.addConstr(2 * hank + 15 * ringo + 16 * bobby >= 18)
m.addConstr(2 * hank + 15 * ringo + 1 * dale >= 22)
m.addConstr(2 * hank + 15 * ringo + 16 * bobby >= 22)
m.addConstr(2 * hank + 15 * ringo + 1 * dale + 16 * bobby >= 22)
m.addConstr(4 * ringo + 15 * dale >= 43)
m.addConstr(14 * hank + 15 * bobby >= 36)
m.addConstr(15 * dale + 15 * bobby >= 23)
m.addConstr(14 * hank + 4 * ringo + 15 * dale + 15 * bobby >= 23)
m.addConstr(7 * dale + 11 * bobby >= 47)
m.addConstr(10 * hank + 7 * dale >= 27)
m.addConstr(3 * ringo + 11 * bobby >= 29)
m.addConstr(10 * hank + 3 * ringo >= 29)
m.addConstr(10 * hank + 11 * bobby >= 76)
m.addConstr(10 * hank + 7 * dale + 11 * bobby >= 65)
m.addConstr(3 * ringo + 7 * dale + 11 * bobby >= 65)
m.addConstr(10 * hank + 3 * ringo + 7 * dale >= 65)
m.addConstr(10 * hank + 7 * dale + 11 * bobby >= 41)
m.addConstr(3 * ringo + 7 * dale + 11 * bobby >= 41)
m.addConstr(10 * hank + 3 * ringo + 7 * dale >= 41)
m.addConstr(10 * hank + 7 * dale + 11 * bobby >= 73)
m.addConstr(3 * ringo + 7 * dale + 11 * bobby >= 73)
m.addConstr(10 * hank + 3 * ringo + 7 * dale >= 73)
m.addConstr(10 * hank + 3 * ringo + 7 * dale + 11 * bobby >= 73)
m.addConstr(4 * dale - 3 * bobby >= 0)
m.addConstr(7 * hank - 10 * dale >= 0)
m.addConstr(15 * ringo + 1 * dale <= 83)
m.addConstr(2 * hank + 1 * dale <= 89)
m.addConstr(2 * hank + 15 * ringo <= 89)
m.addConstr(2 * hank + 15 * ringo + 1 * dale <= 49)
m.addConstr(4 * ringo + 15 * dale <= 143)
m.addConstr(14 * hank + 15 * bobby <= 126)
m.addConstr(14 * hank + 15 * dale <= 104)
m.addConstr(4 * ringo + 15 * bobby <= 101)
m.addConstr(10 * hank + 7 * dale <= 316)
m.addConstr(10 * hank + 3 * ringo + 11 * bobby <= 218)
m.addConstr(3 * ringo + 7 * dale + 11 * bobby <= 219)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

