
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
carrots = m.addVar(vtype=gp.GRB.INTEGER, name="carrots")
sunflowers = m.addVar(vtype=gp.GRB.INTEGER, name="sunflowers")
lilies = m.addVar(vtype=gp.GRB.INTEGER, name="lilies")
carnations = m.addVar(vtype=gp.GRB.INTEGER, name="carnations")
potato_vines = m.addVar(vtype=gp.GRB.INTEGER, name="potato_vines")

# Set objective function
m.setObjective(5*carrots + 9*sunflowers + 8*lilies + 5*carnations + 7*potato_vines, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*lilies + 1*potato_vines >= 11)
m.addConstr(4*sunflowers + 5*lilies >= 15)
m.addConstr(2*carnations + 1*potato_vines >= 20)
m.addConstr(4*sunflowers + 5*lilies + 2*carnations >= 12)
m.addConstr(7*carrots + 2*carnations + 1*potato_vines >= 12)
m.addConstr(7*carrots + 5*lilies + 2*carnations >= 12)
m.addConstr(7*carrots + 4*sunflowers + 5*lilies >= 12)
m.addConstr(7*carrots + 4*sunflowers + 2*carnations >= 12)
m.addConstr(4*sunflowers + 5*lilies + 2*carnations >= 16)
m.addConstr(7*carrots + 2*carnations + 1*potato_vines >= 16)
m.addConstr(7*carrots + 5*lilies + 2*carnations >= 16)
m.addConstr(7*carrots + 4*sunflowers + 5*lilies >= 16)
m.addConstr(7*carrots + 4*sunflowers + 2*carnations >= 16)
m.addConstr(4*sunflowers + 5*lilies + 2*carnations >= 16)
m.addConstr(7*carrots + 2*carnations + 1*potato_vines >= 16)
m.addConstr(7*carrots + 5*lilies + 2*carnations >= 16)
m.addConstr(7*carrots + 4*sunflowers + 5*lilies >= 16)
m.addConstr(7*carrots + 4*sunflowers + 2*carnations >= 16)
m.addConstr(4*sunflowers + 5*lilies + 2*carnations >= 20)
m.addConstr(7*carrots + 2*carnations + 1*potato_vines >= 20)
m.addConstr(7*carrots + 5*lilies + 2*carnations >= 20)
m.addConstr(7*carrots + 4*sunflowers + 5*lilies >= 20)
m.addConstr(7*carrots + 4*sunflowers + 2*carnations >= 20)
m.addConstr(4*sunflowers + 5*lilies + 2*carnations >= 19)
m.addConstr(7*carrots + 2*carnations + 1*potato_vines >= 19)
m.addConstr(7*carrots + 5*lilies + 2*carnations >= 19)
m.addConstr(7*carrots + 4*sunflowers + 5*lilies >= 19)
m.addConstr(7*carrots + 4*sunflowers + 2*carnations >= 19)


m.addConstr(7 * carrots + 5 * carnations >= 27)
m.addConstr(7 * carrots + 4 * potato_vines >= 18)
m.addConstr(5 * carnations + 4 * potato_vines >= 24)
m.addConstr(7 * carrots + 8 * lilies + 5 * carnations >= 29)
m.addConstr(sunflowers + 8 * lilies + 5 * carnations >= 29)
m.addConstr(7 * carrots + sunflowers + 8 * lilies >= 29)
m.addConstr(7 * carrots + 8 * lilies + 5 * carnations >= 25)
m.addConstr(sunflowers + 8 * lilies + 5 * carnations >= 25)
m.addConstr(7 * carrots + sunflowers + 8 * lilies >= 25)
m.addConstr(7 * carrots + 8 * lilies + 5 * carnations >= 26)
m.addConstr(sunflowers + 8 * lilies + 5 * carnations >= 26)
m.addConstr(7 * carrots + sunflowers + 8 * lilies >= 26)

m.addConstr(5*lilies + 2*carnations <= 70)
m.addConstr(4*sunflowers + 2*carnations <= 81)
m.addConstr(7*carrots + 1*potato_vines <= 95)
m.addConstr(5*lilies + 1*potato_vines <= 79)
m.addConstr(7*carrots + 4*sunflowers + 5*lilies + 2*carnations + 1*potato_vines <= 79)
m.addConstr(7*carrots + 1*sunflowers <= 82)
m.addConstr(1*sunflowers + 4*potato_vines <= 56)
m.addConstr(1*sunflowers + 5*carnations <= 146)
m.addConstr(8*lilies + 4*potato_vines <= 129)
m.addConstr(1*sunflowers + 8*lilies + 5*carnations <= 93)
m.addConstr(7*carrots + 8*lilies + 5*carnations <= 114)
m.addConstr(7*carrots + 8*lilies + 4*potato_vines <= 29)
m.addConstr(8*lilies + 5*carnations + 4*potato_vines <= 149)
m.addConstr(7*carrots + 1*sunflowers + 5*carnations <= 98)
m.addConstr(7*carrots + 1*sunflowers + 8*lilies <= 50)
m.addConstr(7*carrots + 1*sunflowers + 8*lilies + 5*carnations + 4*potato_vines <= 50)

m.addConstr(7*carrots + 4*sunflowers + 5*lilies + 2*carnations <= 105)
m.addConstr(7*carrots + sunflowers + 8*lilies + 5*carnations + 4*potato_vines <= 149)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

