
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    carbohydrates = m.addVar(lb=0, name="carbohydrates")
    magnesium = m.addVar(lb=0, name="magnesium")
    calcium = m.addVar(lb=0, name="calcium")
    vitamin_b4 = m.addVar(lb=0, name="vitamin_b4")

    # Set objective function
    m.setObjective(2*carbohydrates + 3*magnesium + 3*calcium + 4*vitamin_b4, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(carbohydrates + 7*magnesium >= 10)
    m.addConstr(carbohydrates + 2*vitamin_b4 >= 8)
    m.addConstr(carbohydrates + 4*calcium >= 5)
    m.addConstr(carbohydrates + 7*magnesium + 4*calcium + 2*vitamin_b4 >= 5)
    m.addConstr(carbohydrates + vitamin_b4 >= 7)
    m.addConstr(carbohydrates + 6*magnesium >= 11)
    m.addConstr(4*calcium + vitamin_b4 >= 13)
    m.addConstr(6*magnesium + vitamin_b4 >= 7)
    m.addConstr(6*magnesium + 4*calcium + vitamin_b4 >= 13)
    m.addConstr(carbohydrates + 6*magnesium + 4*calcium + vitamin_b4 >= 13)
    m.addConstr(7*carbohydrates - 4*calcium >= 0)
    m.addConstr(-2*magnesium + 2*calcium >= 0)
    m.addConstr(carbohydrates + 7*magnesium + 2*vitamin_b4 <= 46)
    m.addConstr(carbohydrates + 4*calcium + 2*vitamin_b4 <= 29)

    # Resource Constraints (upper bounds)
    m.addConstr(carbohydrates + 7*magnesium + 4*calcium + 2*vitamin_b4 <= 56)
    m.addConstr(carbohydrates + 6*magnesium + 4*calcium + vitamin_b4 <= 61)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('carbohydrates:', carbohydrates.x)
        print('magnesium:', magnesium.x)
        print('calcium:', calcium.x)
        print('vitamin_b4:', vitamin_b4.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
