
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x0")  # grams of carbohydrates
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x1")  # milligrams of magnesium
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x2")  # milligrams of calcium
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x3")  # milligrams of vitamin B4

    # Define the objective function
    model.setObjective(2 * x0 + 3 * x1 + 3 * x2 + 4 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(x0 + 7 * x1 >= 10)
    model.addConstr(x0 + 2 * x3 >= 8)
    model.addConstr(x0 + 4 * x2 >= 5)
    model.addConstr(x0 + 7 * x1 + 4 * x2 + 2 * x3 >= 5)
    model.addConstr(x0 + x3 >= 7)
    model.addConstr(x0 + 6 * x1 >= 11)
    model.addConstr(4 * x2 + x3 >= 13)
    model.addConstr(6 * x1 + x3 >= 7)
    model.addConstr(6 * x1 + 4 * x2 + x3 >= 13)
    model.addConstr(x0 + 6 * x1 + 4 * x2 + x3 >= 13)
    model.addConstr(7 * x0 - 4 * x2 >= 0)
    model.addConstr(-2 * x1 + 2 * x2 >= 0)
    model.addConstr(x0 + 7 * x1 + 2 * x3 <= 46)
    model.addConstr(x0 + 4 * x2 + 2 * x3 <= 29)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x0: {x0.varValue}")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
