
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    oranges = m.addVar(lb=0, name="oranges")
    fruit_salads = m.addVar(lb=0, name="fruit_salads")
    bowls_of_cereal = m.addVar(lb=0, name="bowls_of_cereal")


    # Set objective function
    m.setObjective(2*oranges + 9*fruit_salads + 9*bowls_of_cereal, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4*oranges + 4*bowls_of_cereal >= 26, "c1")
    m.addConstr(oranges + 2*bowls_of_cereal >= 13, "c2")
    m.addConstr(oranges + 8*fruit_salads + 2*bowls_of_cereal >= 18, "c3")
    m.addConstr(7*fruit_salads + bowls_of_cereal >= 19, "c4")
    m.addConstr(8*oranges + bowls_of_cereal >= 11, "c5")
    m.addConstr(4*oranges + fruit_salads <= 54, "c6")
    m.addConstr(4*oranges + 4*bowls_of_cereal <= 58, "c7")
    m.addConstr(4*oranges + fruit_salads + 4*bowls_of_cereal <= 58, "c8")
    m.addConstr(oranges + 8*fruit_salads <= 62, "c9")
    m.addConstr(oranges + 2*bowls_of_cereal <= 49, "c10")
    m.addConstr(oranges + 8*fruit_salads + 2*bowls_of_cereal <= 49, "c11")
    m.addConstr(8*oranges + 7*fruit_salads <= 60, "c12")
    m.addConstr(8*oranges + bowls_of_cereal <= 34, "c13")
    m.addConstr(7*fruit_salads + bowls_of_cereal <= 39, "c14")
    m.addConstr(8*oranges + 7*fruit_salads + bowls_of_cereal <= 39, "c15")
    m.addConstr(2*oranges + 8*bowls_of_cereal <= 80, "c16")
    m.addConstr(2*oranges + 6*fruit_salads + 8*bowls_of_cereal <= 80, "c17")
    m.addConstr(4*oranges + fruit_salads + 4*bowls_of_cereal <= 84, "c18")
    m.addConstr(oranges + 8*fruit_salads + 2*bowls_of_cereal <= 65, "c19")
    m.addConstr(8*oranges + 7*fruit_salads + bowls_of_cereal <= 68, "c20")
    m.addConstr(2*oranges + 6*fruit_salads + 8*bowls_of_cereal <= 85, "c21")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The problem is infeasible.")


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
