
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    oranges = model.addVar(name="oranges", lb=0)
    fruit_salads = model.addVar(name="fruit_salads", lb=0)
    bowls_of_cereal = model.addVar(name="bowls_of_cereal", lb=0)

    # Define the objective function
    model.setObjective(2 * oranges + 9 * fruit_salads + 9 * bowls_of_cereal, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * oranges + fruit_salads + 4 * bowls_of_cereal >= 26)
    model.addConstr(oranges + 2 * bowls_of_cereal >= 13)
    model.addConstr(oranges + 8 * fruit_salads + 2 * bowls_of_cereal >= 18)
    model.addConstr(7 * fruit_salads + bowls_of_cereal >= 19)
    model.addConstr(8 * oranges + bowls_of_cereal >= 11)
    model.addConstr(4 * oranges + fruit_salads <= 54)
    model.addConstr(4 * oranges + 4 * bowls_of_cereal <= 58)
    model.addConstr(4 * oranges + fruit_salads + 4 * bowls_of_cereal <= 58)
    model.addConstr(oranges + 8 * fruit_salads <= 62)
    model.addConstr(oranges + 2 * bowls_of_cereal <= 49)
    model.addConstr(oranges + 8 * fruit_salads + 2 * bowls_of_cereal <= 49)
    model.addConstr(8 * oranges + 7 * fruit_salads <= 60)
    model.addConstr(8 * oranges + bowls_of_cereal <= 34)
    model.addConstr(7 * fruit_salads + bowls_of_cereal <= 39)
    model.addConstr(8 * oranges + 7 * fruit_salads + bowls_of_cereal <= 39)
    model.addConstr(2 * oranges + 8 * bowls_of_cereal <= 80)
    model.addConstr(2 * oranges + 6 * fruit_salads + 8 * bowls_of_cereal <= 80)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Oranges: ", oranges.varValue)
        print("Fruit Salads: ", fruit_salads.varValue)
        print("Bowls of Cereal: ", bowls_of_cereal.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
