
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("minimize_hours")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by Jean
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")  # hours worked by Dale
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # hours worked by Paul


    # Set objective function
    m.setObjective(4.5 * x0 + 9.58 * x1 + 5.64 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(6 * x1 + 10 * x2 >= 32, "c0")
    m.addConstr(16 * x0 + 6 * x1 >= 54, "c1")
    m.addConstr(16 * x0 + 6 * x1 + 10 * x2 >= 54, "c2")
    m.addConstr(23 * x1 + 20 * x2 >= 41, "c3")
    m.addConstr(12 * x0 + 23 * x1 + 20 * x2 >= 41, "c4")
    m.addConstr(6 * x1 - 7 * x2 >= 0, "c5")
    m.addConstr(6 * x0 - 5 * x2 >= 0, "c6")
    m.addConstr(6 * x1 + 10 * x2 <= 169, "c7")
    m.addConstr(16 * x0 + 10 * x2 <= 148, "c8")
    m.addConstr(12 * x0 + 23 * x1 <= 116, "c9")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
