
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Jean
x1 = m.addVar(name="x1", lb=0)  # hours worked by Dale
x2 = m.addVar(name="x2", lb=0)  # hours worked by Paul

# Define the objective function
m.setObjective(4.5 * x0 + 9.58 * x1 + 5.64 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * x1 + 10 * x2 >= 32)
m.addConstr(16 * x0 + 6 * x1 >= 54)
m.addConstr(16 * x0 + 6 * x1 + 10 * x2 >= 54)
m.addConstr(23 * x1 + 20 * x2 >= 41)
m.addConstr(12 * x0 + 23 * x1 + 20 * x2 >= 41)
m.addConstr(6 * x1 - 7 * x2 >= 0)
m.addConstr(6 * x0 - 5 * x2 >= 0)
m.addConstr(6 * x1 + 10 * x2 <= 169)
m.addConstr(16 * x0 + 10 * x2 <= 148)
m.addConstr(12 * x0 + 23 * x1 <= 116)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Jean: ", x0.varValue)
    print("Hours worked by Dale: ", x1.varValue)
    print("Hours worked by Paul: ", x2.varValue)
else:
    print("The model is infeasible")
