
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
knishes = m.addVar(vtype=GRB.INTEGER, name="knishes")
kiwis = m.addVar(vtype=GRB.CONTINUOUS, name="kiwis")

# Set objective function
m.setObjective(4 * knishes + 8 * kiwis, GRB.MAXIMIZE)

# Add constraints
m.addConstr(22 * knishes + 28 * kiwis >= 21, "carbohydrates_min")
m.addConstr(14 * knishes + 10 * kiwis >= 40, "calcium_min")
m.addConstr(9 * knishes - 3 * kiwis >= 0, "knishes_kiwis_relation")
m.addConstr(22 * knishes + 28 * kiwis <= 49, "carbohydrates_max")
m.addConstr(14 * knishes + 10 * kiwis <= 77, "calcium_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Number of knishes: {knishes.x}")
    print(f"Number of kiwis: {kiwis.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

